<?php
/**
 * Transfer Character
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

// namespace
namespace Plugin\TransferCharacter;

// plugin root
define('__PATH_TRANSFERCHARACTER_ROOT__', __PATH_PLUGINS__.'transfercharacter/');

// plugin home url
define('__TRANSFERCHARACTER_HOME__', __BASE_URL__.'usercp/transfercharacter/');

// admincp
$extra_admincp_sidebar[] = array(
    'Transfer Character', array(
        array('Settings','transfercharacter&page=settings'),
        array('Logs','transfercharacter&page=logs'),
    )
);

// language phrases
if(file_exists(__PATH_TRANSFERCHARACTER_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) {
	// attempt to load same language as website
	if(!@include_once(__PATH_TRANSFERCHARACTER_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) throw new Exception('Error loading language file (transfercharacter).');
} else {
	// load default language file (en)
	if(!@include_once(__PATH_TRANSFERCHARACTER_ROOT__ . 'languages/en/language.php')) throw new Exception('Error loading language file (transfercharacter).');
}

// load classes
if(!@include_once(__PATH_TRANSFERCHARACTER_ROOT__ . 'classes/class.transfercharacter.php')) throw new Exception(lang('transfercharacter_error_1'));